// The elevator object will start to move when an event calls the Activate(..) method.
// Once it does, it will move until it reaches the goalPos, or it receives a new Activate(..) call
/******************************************************************************/
class Elevator : Game.Kinematic
{
public:
   
    Elevator();
   ~Elevator();
   
   virtual void create(Object &obj);
   virtual bool update();
   
   void Activate(Vec goalPos, flt speed);
   void Enable() { m_Enabled = true; }
   
   Str m_EditorInfo;
   
private:
      
   bool m_Enabled, m_Moving;
   Vec m_GoalPos;
   flt m_Speed;
   
};
/******************************************************************************/
Elevator::Elevator() : m_Enabled(false), m_Speed(0), m_GoalPos(0), m_Moving(false)
{
   
}
Elevator::~Elevator()
{
   
}
/******************************************************************************/
void Elevator::create(Object &obj)
{
   super.create(obj);
   
   if(Param *p = obj.findParam("-EDITOR-INFO")) m_EditorInfo = p.asText();
   if(Param *p = obj.findParam("Enabled"))      m_Enabled    = p.asBool();
   
   // Make the actor kinematic
   actor.mass(100);
   actor.kinematic(true);
}
/******************************************************************************/
bool Elevator::update()
{
   // Only update the position of the elevator when it has to move
   if(m_Moving)
   {
      Vec dir = m_GoalPos - pos();
      dir.normalize();
      
      // Move to: Current position + a small offset in the direction of the goalPos
      kinematicMoveTo(pos() + (dir * m_Speed * Time.d()));
      
      // Elevator has reached its destination, stop moving
      // Pass Time.d() as epsilon, because: The lower your FPS is, the less precise the VectorsApproxEqual can be
      if(MathHelper.VectorsApproxEqual(pos(), m_GoalPos, Time.d()))
      {
         // This is the very last time we set the position: Set it straight to the goal position to have the exact end position
         kinematicMoveTo(m_GoalPos); 
         
         m_Moving = false;
      }
   }
   
   return super.update();
}
/******************************************************************************/
void Elevator::Activate(Vec goalPos, flt speed)
{ 
   if(m_Enabled)
   {
      m_Moving = true;
      m_GoalPos = goalPos;
      m_Speed = speed;
   }
}
